/*
 * Decompiled with CFR 0.152.
 */
package com.pixelsenpai.pixelsanticheat.packet.C2S;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public final class ModListPacket
implements CustomPacketPayload {
    private final List<String> data;
    public static final CustomPacketPayload.Type<ModListPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"pixelsanticheat", (String)"mod_list"));
    public static final StreamCodec<FriendlyByteBuf, ModListPacket> CODEC = CustomPacketPayload.codec(ModListPacket::encode, ModListPacket::decode);

    public ModListPacket(List<String> data) {
        this.data = data;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeVarInt(this.data.size());
        for (String modId : this.data) {
            buf.writeUtf(modId);
        }
    }

    public static ModListPacket decode(FriendlyByteBuf buf) {
        int size = buf.readVarInt();
        ArrayList<String> modList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            modList.add(buf.readUtf());
        }
        return new ModListPacket(modList);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public List<String> data() {
        return this.data;
    }
}

