/*
 * Decompiled with CFR 0.152.
 */
package com.pixelsenpai.pixelsanticheat.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pixelsenpai.pixelsanticheat.PixelsAntiCheat;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\s*\"([^\"]+)\"\\s*:");
    private final Map<String, String> comments = new LinkedHashMap<String, String>();
    private final JsonObject jsonObject = new JsonObject();

    public JsonConfig addComment(String propertyName, String comment) {
        this.comments.put(propertyName, comment);
        return this;
    }

    public JsonConfig addProperty(String propertyName, JsonElement value) {
        this.jsonObject.add(propertyName, value);
        return this;
    }

    public JsonConfig addProperty(String propertyName, String value) {
        this.jsonObject.addProperty(propertyName, value);
        return this;
    }

    public JsonConfig addProperty(String propertyName, Number value) {
        this.jsonObject.addProperty(propertyName, value);
        return this;
    }

    public JsonConfig addProperty(String propertyName, Boolean value) {
        this.jsonObject.addProperty(propertyName, value);
        return this;
    }

    public void write(Path path) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            String jsonString = GSON.toJson((JsonElement)this.jsonObject);
            String[] lines = jsonString.split("\n");
            writer.write(lines[0]);
            writer.newLine();
            for (int i = 1; i < lines.length - 1; ++i) {
                String propertyName;
                String line = lines[i];
                Matcher matcher = PROPERTY_PATTERN.matcher(line);
                if (matcher.find() && this.comments.containsKey(propertyName = matcher.group(1))) {
                    writer.write("  // " + this.comments.get(propertyName));
                    writer.newLine();
                }
                writer.write(line);
                writer.newLine();
            }
            if (lines.length > 1) {
                writer.write(lines[lines.length - 1]);
            }
            writer.flush();
        }
    }

    public static JsonObject read(Path path) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("//")) continue;
                lines.add(line);
            }
        }
        String jsonString = String.join((CharSequence)"\n", lines);
        return JsonParser.parseString((String)jsonString).getAsJsonObject();
    }

    public static boolean validate(Path path) {
        try {
            JsonConfig.read(path);
            return true;
        }
        catch (Exception e) {
            PixelsAntiCheat.LOG.error("Error validating JSON file: {}", (Object)e.getMessage());
            return false;
        }
    }
}

