/*
 * Decompiled with CFR 0.152.
 */
package com.pixelsenpai.pixelsanticheat.server;

import com.pixelsenpai.pixelsanticheat.PixelsAntiCheat;
import com.pixelsenpai.pixelsanticheat.config.ServerConfig;
import com.pixelsenpai.pixelsanticheat.packet.C2S.ModHashPacket;
import com.pixelsenpai.pixelsanticheat.packet.C2S.ModListPacket;
import com.pixelsenpai.pixelsanticheat.packet.C2S.SuspiciousContentPacket;
import com.pixelsenpai.pixelsanticheat.util.HashUtil;
import com.pixelsenpai.pixelsanticheat.util.PlayerInfoHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerHandler {
    private static List<String> forbidMods = new ArrayList<String>();
    private static String serverModHash = null;
    private static final Map<UUID, Long> pendingHashVerification = new HashMap<UUID, Long>();
    private static final int HASH_VERIFICATION_TIMEOUT_TICKS = 200;

    public static void handleModList(ModListPacket p, IPayloadContext c) {
        c.enqueueWork(() -> {
            if (!ServerHandler.isValidClient_Black(p.data(), ServerConfig.getBlackList())) {
                c.disconnect((Component)Component.translatable((String)"pixelsanticheat.forbid_message", (Object[])new Object[]{forbidMods.toString()}));
                forbidMods = new ArrayList<String>();
            }
            if (!ServerHandler.isValidClient_White(p.data(), ServerConfig.getWhiteList())) {
                c.disconnect((Component)Component.translatable((String)"pixelsanticheat.forbid_message", (Object[])new Object[]{forbidMods.toString()}));
                forbidMods = new ArrayList<String>();
            }
            if (c.player() != null && c.player() instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)c.player();
                UUID playerUUID = player.getUUID();
                pendingHashVerification.put(playerUUID, System.currentTimeMillis());
                PixelsAntiCheat.LOG.info("Added player {} to pending hash verification", (Object)player.getName().getString());
            }
        });
    }

    public static void handleModHash(ModHashPacket p, IPayloadContext c) {
        c.enqueueWork(() -> {
            if (serverModHash == null) {
                serverModHash = HashUtil.calculateModHash();
                PixelsAntiCheat.LOG.info("======================================");
                PixelsAntiCheat.LOG.info("SERVER MOD HASH: {}", (Object)serverModHash);
                PixelsAntiCheat.LOG.info("======================================");
            }
            String clientHash = p.hash();
            PixelsAntiCheat.LOG.info("======================================");
            PixelsAntiCheat.LOG.info("CLIENT MOD HASH: {}", (Object)clientHash);
            PixelsAntiCheat.LOG.info("======================================");
            if (c.player() != null && c.player() instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)c.player();
                UUID playerUUID = player.getUUID();
                pendingHashVerification.remove(playerUUID);
                PixelsAntiCheat.LOG.info("Removed player {} from pending hash verification", (Object)player.getName().getString());
            }
            if (!serverModHash.equals(clientHash)) {
                PixelsAntiCheat.LOG.warn("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                PixelsAntiCheat.LOG.warn("CLIENT MOD HASH DOES NOT MATCH SERVER HASH!");
                PixelsAntiCheat.LOG.warn("Server hash: {}", (Object)serverModHash);
                PixelsAntiCheat.LOG.warn("Client hash: {}", (Object)clientHash);
                PixelsAntiCheat.LOG.warn("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                c.disconnect((Component)Component.literal((String)"Pixel's AntiCheat is either not the correct version, or it has been tampered with. Please ensure you have the same version as the server."));
            } else {
                PixelsAntiCheat.LOG.info("Client mod hash matches server hash");
            }
        });
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        long currentTime = System.currentTimeMillis();
        ArrayList<UUID> playersToDisconnect = new ArrayList<UUID>();
        for (Map.Entry<UUID, Long> entry : pendingHashVerification.entrySet()) {
            long timeSinceAdded = currentTime - entry.getValue();
            if (timeSinceAdded <= 10000L) continue;
            playersToDisconnect.add(entry.getKey());
        }
        if (!playersToDisconnect.isEmpty()) {
            for (UUID playerUUID : playersToDisconnect) {
                pendingHashVerification.remove(playerUUID);
                ServerPlayer player = event.getServer().getPlayerList().getPlayer(playerUUID);
                if (player == null) continue;
                PixelsAntiCheat.LOG.warn("Player {} did not send mod hash within timeout period, disconnecting", (Object)PlayerInfoHelper.getPlayerName(player));
                player.connection.disconnect((Component)Component.literal((String)"Failed to verify PixelsAntiCheat integrity. Please ensure you have the correct version installed."));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            UUID playerUUID = PlayerInfoHelper.getPlayerUUID(player);
            pendingHashVerification.remove(playerUUID);
        }
    }

    public static void handleSuspiciousContent(SuspiciousContentPacket p, IPayloadContext c) {
        c.enqueueWork(() -> {
            if (!p.data().isEmpty()) {
                PixelsAntiCheat.LOG.warn("=== SUSPICIOUS CONTENT DETECTED ===");
                PixelsAntiCheat.LOG.warn("Number of suspicious items: {}", (Object)p.data().size());
                for (String content : p.data()) {
                    PixelsAntiCheat.LOG.warn("  - {}", (Object)content);
                }
                if (ServerConfig.getKickOnSuspiciousContent()) {
                    PixelsAntiCheat.LOG.warn("Player will be kicked (KickOnSuspiciousContent=true)");
                    c.disconnect((Component)Component.translatable((String)"pixelsanticheat.suspicious_content_message", (Object[])new Object[]{p.data().toString()}));
                } else {
                    PixelsAntiCheat.LOG.warn("Player will NOT be kicked (KickOnSuspiciousContent=false)");
                }
                PixelsAntiCheat.LOG.warn("=====================================");
            }
        });
    }

    private static boolean isValidClient_White(List<String> clientList, List<String> whiteList) {
        if (whiteList.isEmpty()) {
            return true;
        }
        ServerHandler.forbidMod(clientList, whiteList, "white");
        return forbidMods.isEmpty();
    }

    private static boolean isValidClient_Black(List<String> clientList, List<String> blackList) {
        if (blackList.isEmpty()) {
            return true;
        }
        ServerHandler.forbidMod(clientList, blackList, "black");
        return forbidMods.isEmpty();
    }

    public static void forbidMod(List<String> clientList, List<String> list, String listType) {
        if (listType.equals("white")) {
            HashSet<String> clientSet = new HashSet<String>(clientList);
            clientSet.removeAll(new HashSet<String>(list));
            ArrayList<String> result = new ArrayList<String>(clientSet);
            result.sort(String::compareTo);
            forbidMods = result;
        }
        if (listType.equals("black")) {
            Objects.requireNonNull(list);
            forbidMods = clientList.stream().filter(list::contains).toList();
        }
    }
}

