/*
 * Decompiled with CFR 0.152.
 */
package com.pixelsenpai.pixelsanticheat.packet.C2S;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public final class SuspiciousContentPacket
implements CustomPacketPayload {
    private final List<String> data;
    public static final CustomPacketPayload.Type<SuspiciousContentPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"pixelsanticheat", (String)"suspicious_content"));
    public static final StreamCodec<FriendlyByteBuf, SuspiciousContentPacket> CODEC = CustomPacketPayload.codec(SuspiciousContentPacket::encode, SuspiciousContentPacket::decode);

    public SuspiciousContentPacket(List<String> data) {
        this.data = data;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeVarInt(this.data.size());
        for (String content : this.data) {
            buf.writeUtf(content);
        }
    }

    public static SuspiciousContentPacket decode(FriendlyByteBuf buf) {
        int size = buf.readVarInt();
        ArrayList<String> contentList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            contentList.add(buf.readUtf());
        }
        return new SuspiciousContentPacket(contentList);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public List<String> data() {
        return this.data;
    }
}

