/*
 * Decompiled with CFR 0.152.
 */
package com.pixelsenpai.pixelsanticheat.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;

public class CommentedJsonWriter {
    private final Map<String, String> comments = new LinkedHashMap<String, String>();
    private final JsonObject jsonObject = new JsonObject();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public CommentedJsonWriter addComment(String propertyName, String comment) {
        this.comments.put(propertyName, comment);
        return this;
    }

    public CommentedJsonWriter addProperty(String propertyName, JsonElement value) {
        this.jsonObject.add(propertyName, value);
        return this;
    }

    public CommentedJsonWriter addProperty(String propertyName, String value) {
        this.jsonObject.addProperty(propertyName, value);
        return this;
    }

    public CommentedJsonWriter addProperty(String propertyName, Number value) {
        this.jsonObject.addProperty(propertyName, value);
        return this;
    }

    public CommentedJsonWriter addProperty(String propertyName, Boolean value) {
        this.jsonObject.addProperty(propertyName, value);
        return this;
    }

    public void write(Writer writer) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        String jsonString = this.gson.toJson((JsonElement)this.jsonObject);
        String[] lines = jsonString.split("\n");
        bufferedWriter.write(lines[0]);
        bufferedWriter.newLine();
        for (int i = 1; i < lines.length - 1; ++i) {
            String propertyName;
            String line = lines[i];
            if (line.trim().startsWith("\"") && this.comments.containsKey(propertyName = line.trim().split("\"")[1])) {
                bufferedWriter.write("  // " + this.comments.get(propertyName));
                bufferedWriter.newLine();
            }
            bufferedWriter.write(line);
            bufferedWriter.newLine();
        }
        if (lines.length > 1) {
            bufferedWriter.write(lines[lines.length - 1]);
        }
        bufferedWriter.flush();
    }
}

